
/////////////////////////////////////////////////////////
// general parameters

//transforms

float4x4	shader_transform_world;
float4x4	shader_transform_view;
float4x4	shader_transform_proj;
float4x4	shader_transform_worldView;
float4x4	shader_transform_viewProj;
float4x4	shader_transform_worldViewProj;

//lights

float4		shader_light_position;
float4		shader_light_direction;
float4		shader_light_diffuse;
float4		shader_light_ambient;
float4		shader_light_specular;

//camera

float4 		shader_camera_eyePosition;
float4 		shader_camera_eyeVector;
float4 		shader_camera_upVector;

//material

float4		shader_material_diffuse;
float4		shader_material_ambient;
float4		shader_material_specular;
float		shader_material_eccentricity;
float		shader_material_transparency;
float		shader_material_reflectivity;

//textures

TEXTURE		shader_texture_0;
TEXTURE		shader_texture_1;
TEXTURE		shader_texture_2;
TEXTURE		shader_texture_3;
TEXTURE		shader_texture_4;
TEXTURE		shader_texture_5;
TEXTURE		shader_texture_cubemap;
TEXTURE		shader_texture_shadowmap;

//geometry

float4		shader_geometry_colour;

/////////////////////////////////////////////////////////
// unique parameters

#define		blur_pixelRatio 0.002

/////////////////////////////////////////////////////////
// structures

struct VS_INPUT
{
	float4 position		: POSITION;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};

struct VS_OUTPUT
{
	float4 position		: POSITION;
	float4 colour		: COLOR;
	float2 tex0			: TEXCOORD0;
};

/////////////////////////////////////////////////////////
// functions

VS_OUTPUT vs_glowBlur_y( VS_INPUT input )
{
	VS_OUTPUT output = (VS_OUTPUT) 0;

	output.position = input.position;
	output.colour = input.colour;
	output.tex0 = input.tex0;

	return output;
}

////////////////////////////////////////////////////////////

sampler sampler_colour_0 = sampler_state
{ 
	Texture = (shader_texture_0); 
	MipFilter = NONE;  
	MinFilter = LINEAR;  
	MagFilter = LINEAR;  
	AddressU = Clamp;
	AddressV = Clamp;
};

float4 ps_glowBlur_y( float4 inColour : COLOR, float2 inTex1 : TEXCOORD0 ) : COLOR
{
	float4 finalShade = 
	
		tex2D( sampler_colour_0, float2(inTex1.x, inTex1.y - 4.0 * blur_pixelRatio) ) * 1.0/25.0 +
		tex2D( sampler_colour_0, float2(inTex1.x, inTex1.y - 3.0 * blur_pixelRatio) ) * 2.0/25.0 +
		tex2D( sampler_colour_0, float2(inTex1.x, inTex1.y - 2.0 * blur_pixelRatio) ) * 3.0/25.0 +
		tex2D( sampler_colour_0, float2(inTex1.x, inTex1.y - blur_pixelRatio) ) * 4.0/25.0 +
		tex2D( sampler_colour_0, inTex1 ) * 5.0/25.0 +
		tex2D( sampler_colour_0, float2(inTex1.x, inTex1.y + blur_pixelRatio) ) * 4.0/25.0 +	
		tex2D( sampler_colour_0, float2(inTex1.x, inTex1.y + 2.0 * blur_pixelRatio) ) * 3.0/25.0 +
		tex2D( sampler_colour_0, float2(inTex1.x, inTex1.y + 3.0 * blur_pixelRatio) ) * 2.0/25.0 +	
		tex2D( sampler_colour_0, float2(inTex1.x, inTex1.y + 4.0 * blur_pixelRatio) ) * 1.0/25.0;

	return finalShade;
}

////////////////////////////////////////////////////////////
// techniques

technique tech_glowBlur_y_11_20
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_glowBlur_y();	
		PixelShader = compile ps_2_0 ps_glowBlur_y();
	}
}


technique tech_glowBlur_y_11_00
{
	pass P0
	{
		VertexShader = compile vs_1_1 vs_glowBlur_y();	
	}
}